/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.ast;

import com.veryant.cobol.compiler.Collector;
import com.veryant.cobol.compiler.CompilerMessage;
import com.veryant.cobol.compiler.Magnitude;
import com.veryant.cobol.compiler.Utils;
import com.veryant.cobol.compiler.ast.AstOperand;
import com.veryant.cobol.compiler.frontend.Token;
import com.veryant.cobol.compiler.types.NumericLiteral;
import com.veryant.cobol.data.CobolBigDecimal;

public class AstNumericLiteral
extends AstOperand {
    private static final Magnitude ZERO_MAG = new Magnitude(false, 1, 0);
    private NumericLiteral literal;

    protected AstNumericLiteral(Collector collector, Token token) {
        super(collector, token);
        this.literal = new NumericLiteral(this.getToken(), this.createLiteral("0"), ZERO_MAG, CobolBigDecimal.ZERO);
    }

    protected AstNumericLiteral(Collector collector, Token token, byte[] byArray, Magnitude magnitude, CobolBigDecimal cobolBigDecimal) {
        super(collector, token);
        this.literal = new NumericLiteral(this.getToken(), this.createLiteral(byArray), magnitude, cobolBigDecimal);
        if (magnitude.getDigits() > 18) {
            this.getContext().getLiterals().add(this.literal.getValue());
        }
    }

    @Override
    public NumericLiteral getOperand() {
        return this.literal;
    }

    @Override
    public String toString() {
        return this.literal.toString();
    }

    private static AstNumericLiteral tooBig(Collector collector, Token token) {
        collector.getContext().getConsole().write(new CompilerMessage(38, token, new Object[0]));
        return new AstNumericLiteral(collector, token);
    }

    /*
     * WARNING - void declaration
     */
    public static AstNumericLiteral fromNL(Collector collector, Token token, Token token2, Token token3) {
        byte[] byArray = new byte[collector.getContext().getARITH().getArithOption().getDigits()];
        boolean bl = false;
        boolean bl2 = false;
        Token token4 = null;
        StringBuilder stringBuilder = new StringBuilder();
        if (token != null) {
            token4 = token;
            bl = true;
            bl2 = token.kind == 838;
        }
        int n = 0;
        if (token2 != null) {
            if (token4 == null) {
                token4 = token2;
            }
            stringBuilder.append(token2.image);
            for (char n2 : token2.image.toCharArray()) {
                byArray[n] = (byte)n2;
                if (++n >= byArray.length) break;
            }
        }
        int n3 = 0;
        if (n >= byArray.length) {
            return AstNumericLiteral.tooBig(collector, token4);
        }
        if (token3 != null) {
            void var13_19;
            if (token4 == null) {
                token4 = token3;
            }
            stringBuilder.append(token3.image);
            n3 = -token3.image.length();
            char[] cArray = token3.image.toCharArray();
            int n2 = cArray.length;
            boolean bl3 = false;
            while (var13_19 < n2) {
                char c = cArray[var13_19];
                byArray[n] = (byte)c;
                if (++n >= byArray.length) {
                    return AstNumericLiteral.tooBig(collector, token4);
                }
                ++var13_19;
            }
        }
        CobolBigDecimal cobolBigDecimal = CobolBigDecimal.from(bl2, byArray, 0, n, n3);
        Magnitude magnitude = new Magnitude(bl, n, n3);
        return new AstNumericLiteral(collector, token4, Utils.getBytes(stringBuilder.toString(), collector.getContext().getCodepage()), magnitude, cobolBigDecimal);
    }

    public static AstNumericLiteral fromNL(Collector collector, Token token, Token token2) {
        return AstNumericLiteral.fromNL(collector, token, token2, null);
    }

    public static AstNumericLiteral fromNL(Collector collector, Token token) {
        return AstNumericLiteral.fromNL(collector, null, token, null);
    }

    public static AstNumericLiteral fromHEX(Collector collector, Token token) {
        try {
            token.image = Utils.hexToDec(token.image.substring(2));
        }
        catch (NumberFormatException numberFormatException) {
            token.image = "0";
            collector.getContext().getConsole().write(new CompilerMessage(39, token, new Object[0]));
        }
        return AstNumericLiteral.fromNL(collector, null, token, null);
    }
}

