/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.memory;

import com.veryant.cobol.compiler.ClassFieldSet;
import com.veryant.cobol.compiler.NameGenerator;
import com.veryant.cobol.compiler.memory.DataItem;
import com.veryant.cobol.compiler.memory.DynamicChunk;
import com.veryant.cobol.compiler.memory.IMemoryHandler;
import com.veryant.cobol.compiler.memory.Region;
import java.util.LinkedList;
import java.util.List;

public class CobolData
implements IMemoryHandler<DataItem> {
    private int chunkIndex;
    private int size;
    private final Region region;
    private final boolean optimized;
    private ClassFieldSet fields;
    private NameGenerator nameGenerator;
    private DataItem currentDataItem;
    private final List<DynamicChunk> topLevelDataItems = new LinkedList<DynamicChunk>();

    public DataItem open(DataItem dataItem) {
        ++this.chunkIndex;
        if (this.currentDataItem != null) {
            this.currentDataItem.addChild(dataItem);
            if (this.currentDataItem.getChildrenCount() == 1) {
                --this.chunkIndex;
            }
        }
        this.currentDataItem = dataItem;
        DynamicChunk dynamicChunk = new DynamicChunk(this.chunkIndex, this.currentDataItem.getDeclaredSize(), this.currentDataItem.getDeclaredTimes());
        dynamicChunk.setRegion(this.region);
        if (this.optimized) {
            this.currentDataItem.setChunk(dynamicChunk, this.fields, this.nameGenerator);
        } else {
            this.currentDataItem.setChunk(dynamicChunk);
        }
        return this.currentDataItem.getParent();
    }

    public DynamicChunk close() {
        DynamicChunk dynamicChunk = (DynamicChunk)this.currentDataItem.getChunk();
        this.currentDataItem = this.currentDataItem.getParent();
        if (this.currentDataItem == null) {
            this.topLevelDataItems.add(dynamicChunk);
        } else {
            ((DynamicChunk)this.currentDataItem.getChunk()).add(dynamicChunk);
        }
        return dynamicChunk;
    }

    public DynamicChunk add(DataItem dataItem) {
        this.open(dataItem);
        return this.close();
    }

    public CobolData(Region region) {
        this.region = region;
        this.optimized = false;
    }

    public CobolData(Region region, ClassFieldSet classFieldSet, NameGenerator nameGenerator) {
        this.region = region;
        this.optimized = true;
        this.fields = classFieldSet;
        this.nameGenerator = nameGenerator;
    }

    private int align(int n, int n2) {
        int n3;
        if (n > 1 && (n3 = n % n2) > 0) {
            return n + n2 - n3;
        }
        return n;
    }

    public void relocate(int n) {
        this.size = 0;
        for (DynamicChunk dynamicChunk : this.topLevelDataItems) {
            int n2;
            if (!dynamicChunk.relocate(this.align(this.size, n)) || (n2 = dynamicChunk.getOffset() + dynamicChunk.getPhysicalSize()) <= this.size) continue;
            this.size = n2;
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isOptimized() {
        return this.optimized;
    }
}

