/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.stmts;

import com.veryant.cobol.compiler.ISourceReference;
import com.veryant.cobol.compiler.IStatement;
import com.veryant.cobol.exceptions.COBOLCompilerException;

public abstract class AbstractStatement
implements IStatement {
    private ISourceReference owner;
    private boolean labelNeeded;

    public AbstractStatement(ISourceReference iSourceReference) {
        this.owner = iSourceReference;
    }

    @Override
    public int getRank() {
        return 1;
    }

    @Override
    public void split() {
        throw new COBOLCompilerException("Internal error, invalid code splitting");
    }

    @Override
    public int getSourceLine() {
        return this.owner.getSourceLine();
    }

    @Override
    public int getSourceColumn() {
        return this.owner.getSourceColumn();
    }

    @Override
    public String getSourceFile() {
        return this.owner.getSourceFile();
    }

    public String toString() {
        return this.getStatement() + " (Source File: " + this.getSourceFile() + " Line: " + this.getSourceLine() + " Col: " + this.getSourceColumn() + ")";
    }

    public String getLabel() {
        return "$label$" + this.hashCode();
    }

    public boolean isLabelNeeded() {
        return this.labelNeeded;
    }

    public void setLabelNeeded(boolean bl) {
        this.labelNeeded = bl;
    }
}

